<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Jadwal Servis</h1>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addServisModal">
            <i class="fas fa-plus fa-sm"></i> Tambah Jadwal
        </button>
    </div>

    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert" id="successAlert">
        <i class="fas fa-check-circle me-2"></i>
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <div class="card shadow mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Mobil</th>
                            <th>Tanggal Servis</th>
                            <th>Status</th>
                            <th>Keterangan</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $jadwalServis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $servis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($servis->mobil->nama); ?> - <?php echo e($servis->mobil->plat_nomor); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($servis->tanggal_servis)->format('d/m/Y')); ?></td>
                            <td>
                                <span class="badge bg-<?php echo e($servis->status == 'selesai' ? 'success' : ($servis->status == 'proses' ? 'warning' : 'info')); ?>">
                                    <?php echo e(ucfirst($servis->status)); ?>

                                </span>
                            </td>
                            <td><?php echo e($servis->keterangan); ?></td>
                            <td>
                                <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editServisModal<?php echo e($servis->id); ?>">
                                    <i class="fas fa-edit"></i>
                                </button>
                                
                                <?php if($servis->status == 'proses'): ?>
                                <form action="<?php echo e(route('admin.servis.update', $servis->id)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PATCH'); ?>
                                    <input type="hidden" name="status" value="selesai">
                                    <input type="hidden" name="keterangan" value="<?php echo e($servis->keterangan); ?>">
                                    <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('Apakah servis sudah selesai?')">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </form>
                                <?php endif; ?>
                                
                                <form action="<?php echo e(route('admin.servis.destroy', $servis->id)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Yakin ingin menghapus?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>

                        <!-- Modal Edit -->
                        <div class="modal fade" id="editServisModal<?php echo e($servis->id); ?>" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Update Status Servis</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <form action="<?php echo e(route('admin.servis.update', $servis->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PATCH'); ?>
                                        <div class="modal-body">
                                            <div class="mb-3">
                                                <label class="form-label">Status</label>
                                                <select name="status" class="form-select" required>
                                                    <option value="menunggu" <?php echo e($servis->status == 'menunggu' ? 'selected' : ''); ?>>Menunggu</option>
                                                    <option value="proses" <?php echo e($servis->status == 'proses' ? 'selected' : ''); ?>>Proses</option>
                                                    <option value="selesai" <?php echo e($servis->status == 'selesai' ? 'selected' : ''); ?>>Selesai</option>
                                                </select>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Keterangan</label>
                                                <textarea name="keterangan" class="form-control" rows="3"><?php echo e($servis->keterangan); ?></textarea>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary">Simpan</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center">Tidak ada data jadwal servis</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal Tambah -->
<div class="modal fade" id="addServisModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Jadwal Servis</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="<?php echo e(route('admin.servis.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Mobil</label>
                        <select name="mobil_id" class="form-select" required>
                            <option value="">Cari Mobil </option>
                            <?php $__currentLoopData = $mobil; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($m->id); ?>"><?php echo e($m->nama); ?> - <?php echo e($m->plat_nomor); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tanggal Servis</label>
                        <input type="date" name="tanggal_servis" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Keterangan</label>
                        <textarea name="keterangan" 
                                  class="form-control" 
                                  rows="3"
                                  placeholder="Masukkan keterangan servis">Servis Rutin</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* Existing styles... */
    
    .btn-success {
        background-color: #28a745;
        border-color: #28a745;
    }
    
    .btn-success:hover {
        background-color: #218838;
        border-color: #1e7e34;
    }
    
    /* Spacing between buttons */
    .btn-sm {
        margin: 0 2px;
    }
    
    /* Icon alignment */
    .btn-sm i {
        font-size: 0.875rem;
        line-height: 1;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Auto hide alert after 3 seconds
    window.onload = function() {
        if(document.getElementById('successAlert')) {
            setTimeout(function() {
                document.getElementById('successAlert').style.display = 'none';
            }, 2000); // 3000ms = 3 detik
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\IZSAA\magang\magang-dinas-ketenagakerjaan\resources\views/admin/servis.blade.php ENDPATH**/ ?>